function cb_m43
% Menu 43
% Approximation start values

  global persParamsDir
  global sR0                   
  global isR0Variable                   
  global sC0                  
  global sLs 
  global sRs 
  global sfontsize
  global m43
  
  kw=20/sfontsize;
  capt = get(m43,'label');  
  rowscols = [1,30*kw; 1,30*kw; 1,30*kw; 1,30*kw; 1,30*kw];
  prompt={};
  prompt{1} = 'R0 / kOhm';
  prompt{2} = 'Vary R0? (0 = no, 1 = yes)';
  prompt{3} = 'C0 / pF';
  prompt{4} = 'L(i) / H (enter 3 values, zeros to remove sub coil)';
  prompt{5} = 'R(i) / kOhm (enter 3 values, zeros to remove sub coil)'; 
  defaults{1} = num2str(sR0/1000,4);
  defaults{2} = num2str(isR0Variable);
  defaults{3} = num2str(sC0/1e-12,4);
  defaults{4} = num2str(sLs,4);
  defaults{5} = num2str(sRs/1000,4);
  
  result= inputdlg (prompt, capt, rowscols, defaults);
  
  if ~isempty(result)    
    num=real(str2num(result{1}));    
    if ~isempty(num)
      sR0=num(1,1)*1000;
      if (sR0 < 100) sR0 = 100; end
      if (sR0 > 1e6) sR0 = 1e6; end
    end 
    num=real(str2num(result{2})); 
    if ~isempty(num)   
      isR0Variable=num(1,1);
      if (isR0Variable < 0.5) isR0Variable = false; end
      if (isR0Variable >=0.5) isR0Variable = true; end 
    end 
    num=real(str2num(result{3})); 
    if ~isempty(num)        
      sC0=num(1,1)*1e-12;
      if (sC0 < 1e-12) sC0 = 1e-12; end
      if (sC0 >10e-9) sC0 = 10e-9; end 
    end 
    num=real(str2num(result{4}));    
    if ~isempty(num)
      for i=1:3
        sLs(i)=num(1,i);
        if i == 1
          if (sLs(i) < 0.001) sLs(i) = 0.001; end
        end
        if (sLs(i) > 1000) sLs(i) = 1000; end
      end
    end
    num=real(str2num(result{5})); 
    if ~isempty(num)        
      for i=1:3
        sRs(i)=num(1,i)*1000;
        if i==1
          if (sRs(i) < 100) sRs(i) = 100; end
        end
        if (sRs(i) > 10e9) sRs(i) = 10e9; end
      end
    end 
    if (sLs(3) == 0) || (sRs(3) == 0) 
      sLs(3) = 0;
      sRs(3) = 0;
    end 
    if (sLs(2) == 0) || (sRs(2) == 0) 
      sLs(3) = 0;
      sRs(3) = 0;
      sLs(2) = 0;
      sRs(2) = 0;
    end     
    sn = strcat(persParamsDir,'approxStartValues.mat');
    save('-mat',sn, 'sR0', 'isR0Variable', 'sC0', 'sLs', 'sRs'); 
  end 
  
end